<?php
/* --------------------------------------------------------------
 LayoutLoader.php 2020-02-17
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Admin\Layout\Smarty;

use Gambio\Admin\Layout\Smarty\Loaders\LoaderInterface;
use Gambio\Core\Command\Interfaces\CommandDispatcher;
use Smarty;

/**
 * Class LayoutLoader
 * @package Gambio\Admin\Layout\Smarty
 */
class LayoutLoader implements LoaderInterface
{
    /**
     * @var CommandDispatcher
     */
    private $commandDispatcher;
    
    /**
     * @var LoaderInterface[]
     */
    private $loaders;
    
    
    /**
     * LayoutLoader constructor.
     *
     * @param CommandDispatcher $commandDispatcher
     * @param LoaderInterface[] $loaders
     */
    public function __construct(CommandDispatcher $commandDispatcher, LoaderInterface ...$loaders)
    {
        $this->commandDispatcher = $commandDispatcher;
        $this->loaders           = $loaders;
    }
    
    
    public function load(Smarty $smarty): void
    {
        $command = new LoadLayoutData();
        $this->commandDispatcher->dispatch($command);
        
        $this->loaders = array_merge($this->loaders, $command->loaders());
        
        foreach ($this->loaders as $loader) {
            $loader->load($smarty);
        }
    }
}